%This script generates Tales OA.1, OA.2, and OA.3.

%%%%Table OA.1: Average of the best quoted price in the last period.

%Pre-allocate the matrix to be filled. We have the hyperparameters chosen
%by player 1 in rows and those of player 2 in columns.
MatPrices = zeros(9,9);

for i = 1:9 %Choice of player 1
    
    for j=1:i %Choice of player 2
    % Create the name of the baseline case dataset to be loaded
    dataname = sprintf('Data/last_episodes_%d_%d.txt', i,j); %Corresponds to a simulation where player 1 chooses i and player 2 chooses j
    last_episode = readmatrix(dataname);
    %Get the best final quote in each experiment.
    quotes = min(last_episode(:,1),last_episode(:,2));
    MatPrices(i,j) =mean(quotes); %Record the average best quote in cell (i,j)
    MatPrices(j,i) =mean(quotes); %By symmetry this is also our estimate for cell (j,i)
    end

end

MatPrices_1 = round(MatPrices,2); %Round to two digits
MatPrices_2 = array2table(MatPrices_1);
table2latex(MatPrices_2,'Figures/Table_OA_1.tex'); %Export in .tex


%%%%Table OA.2: Test for profitable deviations from (alpha_m, beta_m) for different K'.

K = 1000;
VectK2 = 100:100:1000; %Create a vector with 10 values of K'
T = 10^6; %Number of episodes

%Compute u bar and s
    dataname = 'Data/last_episodes_5_5.txt'; %
    last_episode = readmatrix(dataname);
    %u is \bar{u}^{\ast} in the paper: the mean (across experiments) of the 
    %average per period profit of player 1.
    u = mean(last_episode(1:K,5)/T);
    %s is \bar{s}^{\ast} in the paper: the standard deviation (across experiments) 
    %of the average per period profit of player 1. 
    %Note that by default std correctly weighs by N-1 and not N.
    s = std(last_episode(1:K,5)/T);

%Now for different values of K' we compute the average \bar{u}^{\prime} and standard
%deviation \bar{s}^{\prime} of all the deviation payoffs, as well as t, nu, and the p-value
%of the test that the deviation is not profitable.

%We pre-allocate two matrices.

%Matu2 is 8 x 10, it records \bar{u}^{\prime} for different deviations theta' (in rows)
%and different experimentation lengths K' (in columns). 
Matu2 = zeros(8,10);

%Matp_eq is 8 x 10, it records the p-value of the test that the deviation is
%not profitable for different deviations theta' (in rows) and different experimentation lengths K' (in columns). 
Matp_eq = zeros(8,10);

%Loop over deviations.
%We denote \theta' by theta2. We start with theta2 < 5.
%Note we exploit the symmetry of the game here: we load the results for
%when player 1 plays 5 and player 2 plays theta2 < 5. We look at the
%deviations of player 2. The payoffs are distributed exactly as the
%payoffs from deviations of player 1 when player 2 plays 5, by
%symmetry.
   
for theta2 = 1:4
    % Create the name of the baseline case dataset to be loaded
    dataname = sprintf('Data/last_episodes_5_%d.txt', theta2); %Data from simulations in which player 1 plays theta = 5 and player 2 plays theta2 < 5.
    %We will look at the profit of player 2. This profit has the same
    %distribution as the profit of player 1 when player 1 plays theta2 and
    %player 2 plays theta = 5.
    last_episode = readmatrix(dataname);

    %Loop over values of K'.
        for i=1:10
        K2 = VectK2(i); %Record the value of K', denoted K2
        %Compute \bar{u}^{\prime}, denoted u2.
        %Note we take column 6, which are the payoffs of player 2.
        u2 = mean(last_episode(1:K2,6)/T);
        %Compute \bar{s}^{\prime}, denoted s2.     
        s2 = std(last_episode(1:K2,6)/T);
        %Compute \Delta \bar{u}, denoted Deltau: 
        Deltau = u2-u;
        %Compute s_{Delta \bar{u}}, denoted sDeltau:
        sDeltau = sqrt(((s2^2)/K2)+((s^2)/K));
        %Compute \nu:
        nu = ((((s2^2)/K2)+((s^2)/K))^2)/((s2^4/((K2^2)*(K2-1)))+(s^4/((K^2)*(K-1))));
        %Compute t:
        t = Deltau /sDeltau;
        %Record \bar{u}^{\prime}: 
        Matu2(theta2,i) = u2;
        %Record the p-value of the test:  
        Matp_eq(theta2,i) = 1-tcdf(t,nu);
        end
end

%We now loop over the values of theta2 > 5.
for theta2 = 6:9
    % Create the name of the baseline case dataset to be loaded
    dataname = sprintf('Data/last_episodes_%d_5.txt', theta2); %This loads simulations results
    %from the experiment in which player 1 used theta2 > 5 and player 2
    %used theta = 5.
    last_episode = readmatrix(dataname);
    %Loop over values of K'.
        for i=1:10
        K2 = VectK2(i);%Record the value of K', denoted K2
        %Compute \bar{u}^{\prime}, denoted u2.
        %Note we look at column 5, payoffs of player 1.
        u2 = mean(last_episode(1:K2,5)/T);
        %Compute \bar{s}^{\prime}, denoted s2.
        s2 = std(last_episode(1:K2,5)/T);
        %Compute \Delta \bar{u}, denoted Deltau: 
        Deltau = u2-u;
        %Compute s_{Delta \bar{u}}, denoted sDeltau:
        sDeltau = sqrt(((s2^2)/K2)+((s^2)/K));
        %Compute \nu:
        nu = ((((s2^2)/K2)+((s^2)/K))^2)/((s2^4/((K2^2)*(K2-1)))+(s^4/((K^2)*(K-1))));
        %Compute t:
        t = Deltau /sDeltau;
        %Record \bar{u}^{\prime}: 
        Matu2(theta2-1,i) = u2;
        %Record the p-value of the test:
        Matp_eq(theta2-1,i) = 1-tcdf(t,nu);
        end
end

Matp_eq = round(Matp_eq,2); %Round to two digits
Matp_eq = array2table(Matp_eq,'VariableNames',{'K^{\prime}=100','K^{\prime}=200','K^{\prime}=300','K^{\prime}=400','K^{\prime}=500','K^{\prime}=600','K^{\prime}=700','K^{\prime}=800','K^{\prime}=900','K^{\prime}=1000'});
table2latex(Matp_eq,'Figures/Table_OA_2.tex') %Export in .tex


%%%%Table OA.3: Minimum p-value for deviations for either player, for all possible strategy pairs and K' = K.

%We will record the minimum p-value across all possible deviations. We initialize with a matrix where all p-values are 1.00.

Matp = ones(9,9);

%Loop over strategies of player 1.
for theta1 = 1:9
    
    %Loop over strategies of player 2.

    %As for Table OA.2, we use the symmetry of the game and focus on cases
    %with theta2 <= theta1. The other cases will be filled by symmetry.
    for theta2 =1:theta1
    %Load the data.
    dataname = sprintf('Data/last_episodes_%d_%d.txt', theta1,theta2); %Loads simulation data from the case
    %in which player 1 chooses parameters theta1 and player 2 chooses theta2
    last_episode = readmatrix(dataname);
    %Compute \bar{u}^{\ast} and \bar{s}^{\ast} for player 1:
        u1 = mean(last_episode(1:K,5)/T);
        s1 = std(last_episode(1:K,5)/T);
    %Compute \bar{u}^{\ast} and \bar{s}^{\ast} for player 2:
        u2 = mean(last_episode(1:K,6)/T);
        s2 = std(last_episode(1:K,6)/T);

        %We check all the deviations of player 1. 
        %First we check deviations towards theta'>=theta2, then theta' <
        %theta2.

        for theta1p = theta2:9 %Loop over all deviations towards theta' >= theta2

            if theta1p~=theta1 %Check this is indeed a deviation
            dataname = sprintf('Data/last_episodes_%d_%d.txt', theta1p,theta2); %Load the simulations from the case in which player 1 uses theta1p and player 2 uses theta2
            last_episode = readmatrix(dataname);
            %Compute \bar{u}^{\prime}, denoted u1p.
            u1p = mean(last_episode(1:K,5)/T);
            %Compute \bar{s}^{\prime}, denoted s1p.
            s1p = std(last_episode(1:K,5)/T);

        %Compute \Delta \bar{u}, denoted Deltau:
        Deltau = u1p-u1;
        %Compute s_{Delta \bar{u}}, denoted sDeltau:
        sDeltau = sqrt(((s1p^2)/K)+((s1^2)/K));
        %Compute \nu:
        nu = ((((s1^2)/K)+((s1p^2)/K))^2)/((s1^4/((K^2)*(K-1)))+(s1p^4/((K^2)*(K-1))));
        %Compute \t:
        t = Deltau /sDeltau;
        %Compute the p-value of the test and record if it is lower than the existing value in the matrix Matp.  
        Matp(theta1,theta2) = min(Matp(theta1,theta2),1-tcdf(t,nu));

            end
        end %End of the loop over all deviations towards theta' >= theta2

        %Now we check deviations towards theta' < theta2

        if theta2>1 %By definition this applies only when theta2 > 1

        for theta1p = 1:theta2-1 %Loop over all deviations of player 1 towards theta' < theta2
            if theta1p~=theta1 %Check this is a deviation
            dataname = sprintf('Data/last_episodes_%d_%d.txt', theta2,theta1p); %Load the simulations from a case in which player 1 plays theta2 and player 2 plays theta'.
            %The profit distribution for player 2 in these simulations is
            %the same as the profit distribution for player 1 when  player
            %1 plays theta' and player 2 plays theta2 (using symmetry).
            last_episode = readmatrix(dataname);
            %Compute \bar{u}^{\prime}, denoted u1p. Note we use the profit
            %of player 2.
            u1p = mean(last_episode(1:K,6)/T);
            %Compute \bar{s}^{\prime}, denoted s1p. 
            s1p = std(last_episode(1:K,6)/T);

        %Compute \Delta \bar{u}, denoted Deltau:
        Deltau = u1p-u1;
        %Compute s_{Delta \bar{u}}, denoted sDeltau:
        sDeltau = sqrt(((s1p^2)/K)+((s1^2)/K));
        %Compute \nu:
        nu = ((((s1^2)/K)+((s1p^2)/K))^2)/((s1^4/((K^2)*(K-1)))+(s1p^4/((K^2)*(K-1))));
        %Compute \t:
        t = Deltau /sDeltau;
        %Compute the p-value of the test and record if it is lower than the existing value in the matrix Matp.  
        Matp(theta1,theta2) = min(Matp(theta1,theta2),1-tcdf(t,nu));

            end
        end %End of the loop over all deviations of player 1 towards theta' < theta2
        end

        %We have considered all the deviations of player 1. We now deal
        %with the deviations of player 2 in the same way.

        %We start with deviations of player 2 to theta2p <= theta1
        if theta1 > 1 %This applies only when theta1 > 1
        for theta2p = 1:theta1 %Loop over all deviations of player 2 to theta2p <= theta1
            if theta2p~=theta2 %Check this is a deviation
            dataname = sprintf('Data/last_episodes_%d_%d.txt', theta1,theta2p); %Load simulation data from the case in which
            %player 1 uses theta1 and player 2 uses theta2p
            last_episode = readmatrix(dataname);
            %Compute \bar{u}^{\prime} for player 2, denoted u2p. 
            u2p = mean(last_episode(1:K,6)/T);
            %Compute \bar{s}^{\prime} for player 2, denoted s2p.
            s2p = std(last_episode(1:K,6)/T);

        %Compute \Delta \bar{u}, denoted Deltau:
        Deltau = u2p-u2;
        %Compute s_{Delta \bar{u}}, denoted sDeltau:
        sDeltau = sqrt(((s2p^2)/K)+((s2^2)/K));
        %Compute \nu:
        nu = ((((s2^2)/K)+((s2p^2)/K))^2)/((s2^4/((K^2)*(K-1)))+(s2p^4/((K^2)*(K-1))));
        %Compute t:
        t = Deltau /sDeltau;
        %Compute the p-value of the test and record if it is lower than the existing value in the matrix Matp.   
        Matp(theta1,theta2) = min(Matp(theta1,theta2),1-tcdf(t,nu));

            end
        end %End of the loop over all deviations of player 2 to theta2p <= theta1
        end


        %We now deal with deviations of player 2 to theta2p > theta1
        if theta1<9 %This applies only when theta1 < 9
        for theta2p = theta1+1:9 %Loop over all values of theta2p > theta1
            if theta2p~=theta2 %Check this is a deviation
            dataname = sprintf('Data/last_episodes_%d_%d.txt', theta2p,theta1); %Load the simulations from a case in which player 1 plays theta2p and player 2 plays theta1.
            %The profit distribution for player 1 in these simulations is the same 
            %as the profit distribution for player 2 when player 2 plays theta2p
            %and player 1 plays theta1 (using symmetry).
            last_episode = readmatrix(dataname);
            %Compute \bar{u}^{\prime} for player 2, denoted u2p. Note we
            %are using column 5, the profit of player 1.
            u2p = mean(last_episode(1:K,5)/T);
            %Compute \bar{s}^{\prime} for player 2, denoted s2p.
            s2p = std(last_episode(1:K,5)/T);

        %Compute \Delta \bar{u}, denoted Deltau:
        Deltau = u2p-u2;
        %Compute s_{Delta \bar{u}}, denoted sDeltau:
        sDeltau = sqrt(((s2p^2)/K)+((s2^2)/K));
        %Compute \nu:
        nu = ((((s2^2)/K)+((s2p^2)/K))^2)/((s2^4/((K^2)*(K-1)))+(s2p^4/((K^2)*(K-1))));
        %Compute t:
        t = Deltau /sDeltau;
        %Compute the p-value of the test and record if it is lower than the existing value in the matrix Matp.   
        Matp(theta1,theta2) = min(Matp(theta1,theta2),1-tcdf(t,nu));

            end
        end %End of the loop over all values of theta2p > theta1
        end

    end
end

%Now we have filled the 9 x 9 matrix Matp with the minimum p-values across
%all deviations of players 1 and 2 in all cases with theta 1 <= theta 2.
%The game being symmetric, Matp has to be symmetric too.
%We fill Matp by symmetry when theta2 > theta1 :

for theta1=1:8 
    for theta2 = theta1+1:9
        Matp(theta1,theta2) = Matp(theta2,theta1);
    end
end

Matp = round(Matp,2); %Round to two digits
Matp= array2table(Matp,'VariableNames',{'(\alpha_l,\beta_l)','(\alpha_l,\beta_m)','(\alpha_l,\beta_h)','(\alpha_m,\beta_l)','(\alpha_m,\beta_m)','(\alpha_m,\beta_h)','(\alpha_h,\beta_l)','(\alpha_h,\beta_m)','(\alpha_h,\beta_h)'});
table2latex(Matp,'Figures/Table_OA_3.tex') %Export in tex
